%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% file: exampleGetMetadata.m                                              %
%                                                                         %
% brief: This is an example for getting metadata.                         %
% note: The intensity output format is not supported by all devices.      %
%       Please refer to the software user manual of your device.          %
%                                                                         %
% autor: Benedikt Radl                                                    %
%                                                                         %
% Copyright (c) 2016 Bluetechnix                                          %
%                                                                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close all;
clear all;

% get a config structure
[status, configStruct] = BTAinitConfig;
if status ~= 0
    error('BTAinitConfig failed. See "status" for error description');
end

% fill the config struct
configStruct.udpDataIpAddr = [224, 0, 0, 1];
configStruct.udpDataIpAddrLen = 4;
configStruct.udpDataPort = 10002;
configStruct.tcpDeviceIpAddr = [192, 168, 0, 10];
configStruct.tcpDeviceIpAddrLen = 4;
configStruct.tcpControlPort = 10001;
configStruct.frameMode = 0; %current config
configStruct.frameQueueMode = 1;
configStruct.frameQueueLength = 5;
configStruct.deviceType = 1; %ETH generic

% open device
[status, deviceHandle] = BTAopen(configStruct);
if status ~= 0
    error('BTAopen failed. See "status" for error description');
end

% set framemode to 24
[status] = BTAwriteRegister(deviceHandle, 4, 192);
if status ~= 0
    statusClose = BTAclose(deviceHandle);
    error('BTAreadRegister failed. See "status" for error description');
end
%wait some time that the changes take effect
pause(2); 

% get one frame
[status, frameHandle, frameCounter, timeStamp] = BTAgetFrame(deviceHandle, 500);
if status ~= 0
    statusClose = BTAclose(deviceHandle);
    error('BTAgetFrame failed. See "status" for error description');
end

% get metadata
channelNr = 0;
metadataId = 2803939590; %BTA_MetadataIdMlxMeta1
% the id of the metadata is defined in bta_frame.h
%       BTA_MetadataIdMlxMeta1 = 0xa720b906,
%       BTA_MetadataIdMlxMeta2 = 0xa720b907,
%       BTA_MetadataIdMlxTest  = 0xa720b908,
%       BTA_MetadataIdMlxAdcData = 0xa720b909,
[status, metadata, metadataLen] = BTAgetMetadata(frameHandle, channelNr, metadataId);
if status ~= 0
    statusFree = BTAfreeFrame(frameHandle);
    statusClose = BTAclose(deviceHandle);
    error('BTAgetMetadata failed. See "status" for error description');
end


% free frame
[status] = BTAfreeFrame(frameHandle);
if status ~= 0
    statusClose = BTAclose(deviceHandle);
    error('BTAfreeFrame failed. See "status" for error description');
end

%close device
status = BTAclose(deviceHandle);
if status ~= 0
	error('BTAclose failed. See "status" for error description');
end
